<?php
    include("config.php");
    include("commonfunctions.php");
    $irpg_page_title = "Les joueurs";
    include("header.php");
?>

  <h1>Les joueurs</h1>
  <h2>Cliquez sur un joueur pour voir son profil complet</h2>
  <p class="small">[gris=d&eacute;connect&eacute;]</p>
  <ol>
<?php
    $file = file($irpg_db);
    unset($file[0]);
    usort($file, 'cmp_level_desc');
    foreach ($file as $line) {
        list($user,,,$level,$class,$secs,,,$online) = explode("\t",trim($line));

        $class = htmlentities($class);
        $next_level = duration($secs);

        print "    <li".(!$online?" class=\"offline\"":"")."><a".
              (!$online?" class=\"offline\"":"").
              " href=\"playerview.php?player=".urlencode($user).
              "\">".htmlentities($user).
              "</a>, le $class de niveau $level. Prochain niveau dans $next_level.</li>\n";

    }
?>
  </ol>

  <p>La liste des joueurs dans un <a href="db.php">tableau</a>.</p>

<?php include("footer.php")?>
